require "prefabutil"

local assets =
{
    Asset("ANIM", "anim/vendingmachine.zip"),
	Asset("ATLAS", "images/inventoryimages/vendingmachine.xml")
}

local prefabs =
{
    "earlkeith",
}

local function onhammered(inst, worker)
    if inst.components.burnable ~= nil and inst.components.burnable:IsBurning() then
        inst.components.burnable:Extinguish()
    end
    inst.components.lootdropper:DropLoot()
    local fx = SpawnPrefab("collapse_small")
    fx.Transform:SetPosition(inst.Transform:GetWorldPosition())
    fx:SetMaterial("wood")
    inst:Remove()
end

local function onhit(inst, worker)
	inst.AnimState:PlayAnimation("idle")
left = 0
end

local function onbuilt(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/sign_craft")
	
end
local function OnRefuseItem(inst, giver, item)
    inst.SoundEmitter:PlaySound("dontstarve/pig/PigKingReject")
end

local function fn()
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
    MakeObstaclePhysics(inst, .2)
	inst.entity:AddDynamicShadow()
	inst.DynamicShadow:SetSize( 3, 3 )
	local gift = 1
    local left = 3
    inst.AnimState:SetBank("vendingmachine")
    inst.AnimState:SetBuild("vendingmachine")
	 	if gift ==1 and left ~=0 then
    inst.AnimState:PlayAnimation("idle5",true) end
	if gift ==2 and left ~=0 then
    inst.AnimState:PlayAnimation("idel2",true) end
	if gift ==3 and left ~=0 then
    inst.AnimState:PlayAnimation("idle3",true) end
	if gift ==4 and left ~=0 then
    inst.AnimState:PlayAnimation("idle4",true) end
	if left == 0 then
    inst.AnimState:PlayAnimation("idle",true) end
	
    MakeSnowCoveredPristine(inst)
    inst:AddTag("structure")
    inst:AddTag("sign")
    inst.entity:SetPristine()
    if not TheWorld.ismastersim then
        return inst
    end
--------------------------------

local function OnIsDay(inst)
local n = math.random(1,4)
 gift = n
 left = 3
	if gift ==1 and left ~=0 then
    inst.AnimState:PlayAnimation("idle5",true) end
	if gift ==2 and left ~=0 then
    inst.AnimState:PlayAnimation("idel2",true) end
	if gift ==3 and left ~=0 then
    inst.AnimState:PlayAnimation("idle3",true) end
	if gift ==4 and left ~=0 then
    inst.AnimState:PlayAnimation("idle4",true) end
end
------------交易组件------------
  local function ShouldAcceptItem(inst, item)
    local player = GetPlayer()
    if player.components.inventory:Has("earlkeith", 3) and left ~= 0
	then
       if item.prefab == "earlkeith" then
        return true
        end
    end
    return false
end
------提取系统-----------------
local function OnGetItemFromPlayer(inst, giver, item)

 if item.prefab == "earlkeith" then
	
	giver.components.inventory:ConsumeByName("earlkeith", 2)
	 
	if gift == 1 
	then
	
     for k = 1, 5 do
	giver.components.inventory:GiveItem( SpawnPrefab("goldnugget"))
	 end left = left-1 end
	 	if gift == 2
	then
	
     for k = 1, 5 do
	giver.components.inventory:GiveItem( SpawnPrefab("poop"))
	 end left = left-1 end
	 	if gift == 3
	then
	left = left-1
	giver.components.inventory:GiveItem( SpawnPrefab("kabobs"))
	 end
	 	if gift == 4
	then
	left = left-1
	giver.components.inventory:GiveItem( SpawnPrefab("ratatouille"))
	 end
   if left == 0 then inst.AnimState:PlayAnimation("idle",true) end
 end
end
--------------------------------
	inst:AddComponent("workable")
	
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(75)
    inst.components.workable:SetOnFinishCallback(onhammered)
    inst.components.workable:SetOnWorkCallback(onhit)
    inst:AddComponent("inspectable")
	inst:AddComponent("inventory")
    inst:AddComponent("lootdropper")
	inst:ListenForEvent("onbuilt", onbuilt)
	inst:AddComponent("trader")
    inst.components.trader.onaccept = OnGetItemFromPlayer
    inst.components.trader:SetAcceptTest(ShouldAcceptItem)
	MakeHauntableWork(inst)
	--检查
	inst:AddComponent("talker")
	inst:AddComponent("inspectable")
	inst.components.inspectable.getstatus = function(inst,viewer)
	local say = ""
	if left == 0 then inst.components.talker:Say("货物已经被买完了，请等到晚上本机补货。") end
	if left ~= 0 and  gift ==1 then inst.components.talker:Say("当前出售[金块x5]，剩余:"..tostring(left)) end
	if left ~= 0 and  gift ==2 then inst.components.talker:Say("当前出售[粪便x5]，剩余:"..tostring(left)) end
	if left ~= 0 and  gift ==3 then inst.components.talker:Say("当前出售[肉串x1]，剩余:"..tostring(left)) end
	if left ~= 0 and  gift ==4 then inst.components.talker:Say("当前出售[蹩脚炖菜x1]，剩余:"..tostring(left)) end
	
	return say
	end
--每天补货
inst:WatchWorldState("isnight", OnIsDay)
    
		----保存载入
local function onsave(inst, data)
    data.left = left 
	data.gift = gift
end
 local function onload (inst, data)
    if data ~= nil
     then
		left = data.left
		gift = data.gift
		print(tostring(left));
		print(tostring(gift));
	if gift ==1 and left ~=0 then
    inst.AnimState:PlayAnimation("idle5",true) end
	if gift ==2 and left ~=0 then
    inst.AnimState:PlayAnimation("idel2",true) end
	if gift ==3 and left ~=0 then
    inst.AnimState:PlayAnimation("idle3",true) end
	if gift ==4 and left ~=0 then
    inst.AnimState:PlayAnimation("idle4",true) end
	if left == 0 then
    inst.AnimState:PlayAnimation("idle",true) end
     end
end	
inst.OnSave = onsave
inst.OnLoad = onload
return inst
end
return Prefab("vendingmachine", fn, assets, prefabs)